<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

/*
The script's version number.
Anytime the version number is changed, it just has to be edited here.
*/
$version_num = '1.4.0';



/* Let's get started! */


// Report any and all errors that go wrong during this installation
error_reporting(E_ALL);

// Declare the functions and start the HTML output
require ("../admin/functions.php");
	$start_time = micro_time(0);
	bodyHeader('install', $version_num);
	bodyNavigation('install');

/*
During the installation, there are multiple steps.  The user is passed to the next step
through a POST variable sent from the previous page. This checks what page the user is on.
*/
if (isset($_POST['step'])) {
	$current_step = $_POST['step'];
} else {
	$current_step = 1;
}
?>

<div id="installation-progress-bar">
	<div>
		<p class="sideBarTitle">Installation Progress</p>
		<ul>
			<?php
			/*
			 * Highlight the step in the sidebar that the user is currently on.
			*/
			?>
			<li<?php if ($current_step == 1) echo " class=\"selected\""; ?>>&rsaquo; Requirements</li>
			<li<?php if ($current_step == 2) echo " class=\"selected\""; ?>>&rsaquo; License</li>
			<li<?php if ($current_step == 3) echo " class=\"selected\""; ?>>&rsaquo; Server Info</li>
			<li<?php if ($current_step == 4) echo " class=\"selected\""; ?>>&rsaquo; Settings</li>
			<li<?php if ($current_step == 5) echo " class=\"selected\""; ?>>&rsaquo; Finished</li>
		</ul>
	</div>
</div>

<div id="main-copy">

<?php
/*
Begin first step
*/
if ($current_step == 1) {

/*
The $discontinue_install variable is set to true after any of the requirements are not met.
If this value is set to TRUE, the "Continue" button is disabled.
*/
$discontinue_install = false;

// Try to automatically CHMOD the configuration files to writable status:
	@chmod('../config_admin.php', 0666);
	@chmod('../config_database.php', 0666);
	@chmod('../config_settings.php', 0666);
?>

	<h1>Installation Overview</h1>

	<p>Welcome and thank you for downloading AdLogger. In just a few moments, you will be ready to begin using this script.</p>
	<p>For detailed instructions on setting up AdLogger, please visit the <a href="http://www.adlogger.org/index.php/Documentation" title="AdLogger Official Documentation" target="_blank">online documentation</a>.</p>
	<p>A couple basic PHP requirements must be met in order to use the script. Please verify that you have completed the following pre-installation tasks before continuing.</p>

	<p><strong>Step 1: </strong>CHMOD the configuration files to 666.</p>
	<p><strong>Step 2: </strong>Prepare a database for AdLogger through your server's control panel.</p>

	<h1>Requirements Verification</h1>
	<br />

		<form name="form1" method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>">
			<fieldset>
				<legend>Requirements</legend>
	
				<label>config_admin.php writable:</label>
						<?php
							/*
							Check the permissions of the config_admin file.
							It must be writable so that the installation script can write the
							necessary values to it.
							If it's not, don't let the user continue with the installation.
							*/
							if (!check_permissions('../config_admin.php')) {
								echo '<span class="install-OK">Complete</span>';
							} else {
								echo '<span class="install-NotOK">Incomplete</span>';
								$discontinue_install = true;
							}
						?>
	
				<br /><br />
	
				<label>config_database.php writable:</label>
						<?php
							/*
							Check the permissions of the config_database file.
							It must be writable so that the installation script can write the
							necessary values to it.
							If it's not, don't let the user continue with the installation.
							*/
							if (!check_permissions('../config_database.php')) {
								echo '<span class="install-OK">Complete</span>';
							} else {
								echo '<span class="install-NotOK">Incomplete</span>';
								$discontinue_install = true;
							}
						?>

				<br /><br />

				<label>config_settings.php writable:</label>
						<?php
							/*
							Check the permissions of the config_settings file.
							It must be writable so that the installation script can write the
							necessary values to it.
							If it's not, don't let the user continue with the installation.
							*/
							if (!check_permissions('../config_settings.php')) {
								echo '<span class="install-OK">Complete</span>';
							} else {
								echo '<span class="install-NotOK">Incomplete</span>';
								$discontinue_install = true;
							}
						?>

				<br /><br />

				<label>PHP GD Library Enabled:</label>
						<?php
							/*
							Check if the GD Library is installed.  Needed for displaying
							color attributes of clicked ads.
							*/
							if (extension_loaded('gd') && function_exists('gd_info')) {
								$gd_enabled = 'true';
								echo '<span class="install-OK">Complete</span>';
							} else {
								$gd_enabled = 'false';
								echo '<span class="install-Warning">Warning</span>';
							}
						?>

				<br />

			</fieldset>

			<fieldset>
				<legend>Continue</legend>

				<input type="hidden" name="gd_enabled" value="<?php echo $gd_enabled; ?>" />
				<input name="step" type="hidden" id="step" value="2" />

				<div align="center">
					<?php
						/*
						If the requirements weren't met,
						produce an error and disable the Continue button.
						*/
						if ($discontinue_install) { ?>
							<strong>Before installation can continue, the above requirements must be satisfied.</strong>

							<br /><br />

							Click here to <a href="<?php echo $_SERVER['REQUEST_URI']; ?>">refresh</a> this page once you're ready.

							<br /><br />

							<input type="submit" name="Submit" value="Continue" disabled="disabled" />
					<?php } else { ?>
							<input type="submit" name="Submit" value="Continue" />
					<?php } ?>
				</div>
			</fieldset>
		</form>

<?php }
// If the user is at step 2, show the license agreement.
elseif ($current_step == 2) {
?>

	<h1>License Agreement</h1>
	<p>Please familiarize yourself with the GNU General Public License, under which AdLogger is licensed.</p>

	<div id="licenseFrameInstall">
		<br />
		<h2 align="center">The GNU General Public License (GPL)</h2>
		<h3 align="center">Version 2, June 1991</h3>

		<p>Copyright (C) 1989, 1991 Free Software Foundation, Inc. 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA</p>
		<p>Everyone is permitted to copy and distribute verbatim copies of this license document, but changing it is not allowed.</p>

		<p><strong>Preamble</strong></p>

		<p>The licenses for most software are designed to take away your freedom to share and change it.  By contrast, the GNU General Public License is intended to guarantee your freedom to share and change free software--to make sure the software is free for all its users.  This General Public License applies to most of the Free Software Foundation's software and to any other program whose authors commit to using it.  (Some other Free Software Foundation software is covered by the GNU Library General Public License instead.)  You can apply it to your programs, too.</p>
		<p>When we speak of free software, we are referring to freedom, not price. Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for this service if you wish), that you receive source code or can get it if you want it, that you can change the software or use pieces of it in new free programs; and that you know you can do these things.</p>
		<p>To protect your rights, we need to make restrictions that forbid anyone to deny you these rights or to ask you to surrender the rights. These restrictions translate to certain responsibilities for you if you distribute copies of the software, or if you modify it.</p>
		<p>For example, if you distribute copies of such a program, whether gratis or for a fee, you must give the recipients all the rights that you have.  You must make sure that they, too, receive or can get the source code.  And you must show them these terms so they know their rights.</p>
		<p>We protect your rights with two steps: (1) copyright the software, and (2) offer you this license which gives you legal permission to copy, distribute and/or modify the software.</p>
		<p>Also, for each author's protection and ours, we want to make certain that everyone understands that there is no warranty for this free software.  If the software is modified by someone else and passed on, we want its recipients to know that what they have is not the original, so that any problems introduced by others will not reflect on the original authors' reputations.</p>
		<p>Finally, any free program is threatened constantly by software patents.  We wish to avoid the danger that redistributors of a free program will individually obtain patent licenses, in effect making the program proprietary.  To prevent this, we have made it clear that any patent must be licensed for everyone's free use or not licensed at all.</p>
		<p>The precise terms and conditions for copying, distribution and modification follow.</p>

		<p><strong>TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION</strong></p>

		<p><strong>0</strong>. This License applies to any program or other work which contains a notice placed by the copyright holder saying it may be distributed under the terms of this General Public License.  The "Program", below, refers to any such program or work, and a "work based on the Program" means either the Program or any derivative work under copyright law: that is to say, a work containing the Program or a portion of it, either verbatim or with modifications and/or translated into another language.  (Hereinafter, translation is included without limitation in the term "modification".)  Each licensee is addressed as "you".</p>
		<p>Activities other than copying, distribution and modification are not covered by this License; they are outside its scope.  The act of running the Program is not restricted, and the output from the Program is covered only if its contents constitute a work based on the Program (independent of having been made by running the Program). Whether that is true depends on what the Program does.</p>
		<p><strong>1</strong>. You may copy and distribute verbatim copies of the Program's source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice and disclaimer of warranty; keep intact all the notices that refer to this License and to the absence of any warranty; and give any other recipients of the Program a copy of this License along with the Program.</p>
		<p>You may charge a fee for the physical act of transferring a copy, and you may at your option offer warranty protection in exchange for a fee.</p>
		<p><strong>2</strong>. You may modify your copy or copies of the Program or any portion of it, thus forming a work based on the Program, and copy and distribute such modifications or work under the terms of Section 1 above, provided that you also meet all of these conditions:</p>
		<blockquote>
			<p>a) You must cause the modified files to carry prominent notices     stating that you changed the files and the date of any change.</p> <p>b) You must cause any work that you distribute or publish, that in     whole or in part contains or is derived from the Program or any     part thereof, to be licensed as a whole at no charge to all third     parties under the terms of this License.</p> <p>c) If the modified program normally reads commands interactively     when run, you must cause it, when started running for such     interactive use in the most ordinary way, to print or display an     announcement including an appropriate copyright notice and a     notice that there is no warranty (or else, saying that you provide     a warranty) and that users may redistribute the program under     these conditions, and telling the user how to view a copy of this     License.  (Exception: if the Program itself is interactive but     does not normally print such an announcement, your work based on     the Program is not required to print an announcement.)</p>
		</blockquote>
		<p>These requirements apply to the modified work as a whole.  If identifiable sections of that work are not derived from the Program, and can be reasonably considered independent and separate works in themselves, then this License, and its terms, do not apply to those sections when you distribute them as separate works.  But when you distribute the same sections as part of a whole which is a work based on the Program, the distribution of the whole must be on the terms of this License, whose permissions for other licensees extend to the entire whole, and thus to each and every part regardless of who wrote it.</p>
		<p>Thus, it is not the intent of this section to claim rights or contest your rights to work written entirely by you; rather, the intent is to exercise the right to control the distribution of derivative or collective works based on the Program.</p>
		<p>In addition, mere aggregation of another work not based on the Program with the Program (or with a work based on the Program) on a volume of a storage or distribution medium does not bring the other work under the scope of this License.</p>
		<p><strong>3</strong>. You may copy and distribute the Program (or a work based on it, under Section 2) in object code or executable form under the terms of Sections 1 and 2 above provided that you also do one of the following:</p>
		<blockquote>
			<p>a) Accompany it with the complete corresponding machine-readable     source code, which must be distributed under the terms of Sections     1 and 2 above on a medium customarily used for software interchange; or,</p> <p>b) Accompany it with a written offer, valid for at least three     years, to give any third party, for a charge no more than your     cost of physically performing source distribution, a complete     machine-readable copy of the corresponding source code, to be     distributed under the terms of Sections 1 and 2 above on a medium     customarily used for software interchange; or,</p> <p>c) Accompany it with the information you received as to the offer     to distribute corresponding source code.  (This alternative is     allowed only for noncommercial distribution and only if you     received the program in object code or executable form with such     an offer, in accord with Subsection b above.)</p>
		</blockquote>
		<p>The source code for a work means the preferred form of the work for making modifications to it.  For an executable work, complete source code means all the source code for all modules it contains, plus any associated interface definition files, plus the scripts used to control compilation and installation of the executable.  However, as a special exception, the source code distributed need not include anything that is normally distributed (in either source or binary form) with the major components (compiler, kernel, and so on) of the operating system on which the executable runs, unless that component itself accompanies the executable.</p>
		<p>If distribution of executable or object code is made by offering access to copy from a designated place, then offering equivalent access to copy the source code from the same place counts as distribution of the source code, even though third parties are not compelled to copy the source along with the object code.</p>
		<p><strong>4</strong>. You may not copy, modify, sublicense, or distribute the Program except as expressly provided under this License.  Any attempt otherwise to copy, modify, sublicense or distribute the Program is void, and will automatically terminate your rights under this License. However, parties who have received copies, or rights, from you under this License will not have their licenses terminated so long as such parties remain in full compliance.</p>
		<p><strong>5</strong>. You are not required to accept this License, since you have not signed it.  However, nothing else grants you permission to modify or distribute the Program or its derivative works.  These actions are prohibited by law if you do not accept this License.  Therefore, by modifying or distributing the Program (or any work based on the Program), you indicate your acceptance of this License to do so, and all its terms and conditions for copying, distributing or modifying the Program or works based on it.</p>
		<p><strong>6</strong>. Each time you redistribute the Program (or any work based on the Program), the recipient automatically receives a license from the original licensor to copy, distribute or modify the Program subject to these terms and conditions.  You may not impose any further restrictions on the recipients' exercise of the rights granted herein. You are not responsible for enforcing compliance by third parties to this License.</p>
		<p><strong>7</strong>. If, as a consequence of a court judgment or allegation of patent infringement or for any other reason (not limited to patent issues), conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License.  If you cannot distribute so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may not distribute the Program at all.  For example, if a patent license would not permit royalty-free redistribution of the Program by all those who receive copies directly or indirectly through you, then the only way you could satisfy both it and this License would be to refrain entirely from distribution of the Program.</p>
		<p>If any portion of this section is held invalid or unenforceable under any particular circumstance, the balance of the section is intended to apply and the section as a whole is intended to apply in other circumstances.</p>
		<p>It is not the purpose of this section to induce you to infringe any patents or other property right claims or to contest validity of any such claims; this section has the sole purpose of protecting the integrity of the free software distribution system, which is implemented by public license practices.  Many people have made generous contributions to the wide range of software distributed through that system in reliance on consistent application of that system; it is up to the author/donor to decide if he or she is willing to distribute software through any other system and a licensee cannot impose that choice.</p>
		<p>This section is intended to make thoroughly clear what is believed to be a consequence of the rest of this License.</p>
		<p><strong>8</strong>. If the distribution and/or use of the Program is restricted in certain countries either by patents or by copyrighted interfaces, the original copyright holder who places the Program under this License may add an explicit geographical distribution limitation excluding those countries, so that distribution is permitted only in or among countries not thus excluded.  In such case, this License incorporates the limitation as if written in the body of this License.</p>
		<p><strong>9</strong>. The Free Software Foundation may publish revised and/or new versions of the General Public License from time to time.  Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.</p>
		<p>Each version is given a distinguishing version number.  If the Program specifies a version number of this License which applies to it and "any later version", you have the option of following the terms and conditions either of that version or of any later version published by the Free Software Foundation.  If the Program does not specify a version number of this License, you may choose any version ever published by the Free Software Foundation.</p>
		<p><strong>10</strong>. If you wish to incorporate parts of the Program into other free programs whose distribution conditions are different, write to the author to ask for permission.  For software which is copyrighted by the Free Software Foundation, write to the Free Software Foundation; we sometimes make exceptions for this.  Our decision will be guided by the two goals of preserving the free status of all derivatives of our free software and of promoting the sharing and reuse of software generally.</p>
		<p><strong>NO WARRANTY</strong></p>
		<p><strong>11</strong>. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.</p>
		<p><strong>12</strong>. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</p>

		<h3 align="center">END OF TERMS AND CONDITIONS</h3>

	</div>

	<br />

	<form name="install_license_agreement" method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>" onsubmit="return validate_license_agreement(this);">
		
		<fieldset>
			<legend>Continue</legend>
			
			<div align="center">
				<input type="checkbox" name="agree_license_terms_check" />
				I have read and agree to the terms of the GNU General Public License.
				<br />
				<input name="step" type="hidden" id="step" value="3" />
				<input type="hidden" name="gd_enabled" value="<?php echo $_POST['gd_enabled']; ?>" />
				<input type="submit" name="Submit" value="Continue" />
			</div>
			
		</fieldset>

	</form>




<?php }
// If the user is at step 3, perform this code
elseif ($current_step == 3) {

/*
Check to make sure they agreed to the terms and conditions of the license.
If they didn't, produce an error and direct them back to the previous page.
*/
if (empty($_POST['agree_license_terms_check'])) { ?>
	<h1>Error!</h1>
	<p>You must agree to the terms of the license before you can continue.</p>
	</div>
<?php bodyFooter('error', $start_time); exit(); }

/*
Now, have the user input all his server information.
Database info and absolute location of the AdLogger directory.
*/
?>
	<h1>Server Information</h1>
	<p>Please enter the information for your MySQL server.</p>

		<form name="install_step_2" method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>" onsubmit="return validate_step_2(this);">
			<fieldset>
				<legend>Database Location Info</legend>
				<label for="db_host"><strong>Database Host: </strong></label>
				<input name="db_host" type="text" id="db_host" value="localhost" size="50" />
				<br />
				<label>The default hostname is 'localhost'.</label>
				<br />
				<br />
				
				<label for="db_port"><strong>Database Port: </strong></label>
				<input name="db_port" type="text" id="db_port" value="3307" size="50" />
				<br />
				<label>The default port is 3307.</label>
				<br />
			</fieldset>

			<br />

			<fieldset>
				<legend>Database Credentials</legend>
				<label for="db_name"><strong>Database Name: </strong></label>
				<input name="db_name" type="text" id="db_name" size="50" />
				<br />
				<label>The MySQL database to install AdLogger</label>
				<br />
				<br />
				
				<label for="db_user"><strong>Database Username: </strong></label>
				<input name="db_user" type="text" id="db_user" size="50" />
				<br />
				<label>The username to access your MySQL database</label>
				<br />
				<br />
				
				<label for="db_pass"><strong>Database Password: </strong></label>
				<input name="db_pass" type="password" id="db_pass" size="50" />
				<br />
				<label>The password to access your MySQL database</label>
				<br />
				<br />
				
				<label for="db_table_prefix"><strong>Table Prefix: </strong></label>
				<input name="db_table_prefix" type="text" id="db_table_prefix" value="adlogger_" size="50" />
				<br />
				<label>Optional table prefix for the database tables created</label>
				<br />
			</fieldset>

			<br />

			<fieldset>
				<legend>AdLogger Location Info</legend>
				<p align="center">These values should have been automatically populated. You probably will not have to change them.</p>
				<label for="siteurl"><strong>Site URL: </strong></label>
				<input name="siteurl" type="text" id="siteurl" value="<?php echo "http://" . $_SERVER['SERVER_NAME']; ?>" size="50" />
				<br />
				<label>Site where AdLogger is being installed</label>
				<br />
				<br />

				<label for="adlogger_loc"><strong>AdLogger Directory: </strong></label>
				<input name="adlogger_loc" type="text" id="adlogger_loc" value="<?php echo preg_replace("/\/install\/[index\.php]*/", '', $_SERVER['PHP_SELF']); ?>" size="50" />
				<br />
				<label>Web directory of AdLogger files</label>
				<br />
				<br />

				<label for="adlogger_doc_path"><strong>AdLogger Document Path: </strong></label>
				<input name="adlogger_doc_path" type="text" id="adlogger_doc_path" value="<?php echo preg_replace("/\/install\/[index\.php]*/", '', __FILE__); ?>" size="50" />
				<br />
				<label>Absolute document path to the AdLogger files</label>
				<br />
			</fieldset>

			<br />
			
			<fieldset>
				<legend>Continue</legend>
				<label for="submit">&nbsp;</label>
				<input name="step" type="hidden" id="step" value="4" />
				<input type="hidden" name="gd_enabled" value="<?php echo $_POST['gd_enabled']; ?>" />
				<input type="submit" name="Submit" value="Continue" />
			</fieldset>

		</form>

<?php }
/*
If the user is at step 4, perform this code.
In step 4, it creates two files: config_database.php and config_admin.php
And it sets up the tables in the database
*/
elseif ($current_step == 4) {

// Get and declare all the variables that have been posted from the previous step
$db_host = $_POST['db_host'];
$db_port = $_POST['db_port'];
$db_user = $_POST['db_user'];
$db_pass = $_POST['db_pass'];
$db_name = $_POST['db_name'];
$db_table_prefix = $_POST['db_table_prefix'];
$siteurl = $_POST['siteurl'];
$adlogger_loc = $_POST['adlogger_loc'];
$adlogger_doc_path = $_POST['adlogger_doc_path'];

$gd_enabled = $_POST['gd_enabled'];

/*
Even though we told the user not to add a trailing slash to any of the location variables,
let's go ahead and double check, just to make sure they were listening.
*/
if ((preg_match("/\/\z/", $siteurl)) || (preg_match("/\/\z/", $adlogger_loc)) || (preg_match("/\/\z/", $adlogger_doc_path))) { ?>
	<h1>Error!</h1>
	<p>The location values can not have a trailing slash. If they do, the script won't function properly. Please correct the following:</p>
	<p>Example: <strong>http://www.adlogger.org/</strong> is invalid but <strong>http://www.adlogger.org</strong> is valid.
	<ul>
		<li>Site URL</li>
		<li>AdLogger Directory</li>
		<li>AdLogger Document Path</li>
	</ul>
	<p>The script should have been able to properly determine those values on its own. Please go back and try again.</p>
	</div>
<?php bodyFooter('error', $start_time); exit(); }

// If the user left the database hostname entry empty, use the default "localhost"
if (empty($db_host)) {
	$db_host = 'localhost';
}

// If the user left the database table prefix empty, use "adlogger_"
if (empty($db_table_prefix)) {
	$db_table_prefix = 'adlogger_';
}

/*
If the user specified a port OTHER than the default "3307",
add it to the hostname so the script can connect to it.
If it is left at 3307, it's not needed, so you can forget about it.
*/
if ($db_port != '3307') {
	$db_host = $db_host . ":" . $db_port;
}

/*
Before actually saving the connection info, let's do a test.
This will test a database connection using the given hostname, port, username, and password.
If it can't connect, it produces an error and directs them to the previous page.
*/
$test_mysql_connection = @mysql_connect("$db_host", "$db_user", "$db_pass");
if (!$test_mysql_connection) { ?>
	<h1>Error!</h1>
	<p>The database connection info you provided isn't working properly. This is caused by one of three things:</p>
	<ul>
		<li>Incorrect database hostname or port</li>
		<li>Incorrect username for database</li>
		<li>Incorrect password for that user</li>
	</ul>
	<p>Please go back and try again.</p>
	</div>
<?php bodyFooter('error', $start_time); exit(); }

/*
Again, before actually trying to put data in the database, let's do another test.
This will test accessing the given database table.
If it can't select the database, it produces an error and direct them to the previous page.
*/
$test_mysql_db_selection = @mysql_select_db("$db_name");
if (!$test_mysql_db_selection) { ?>
	<h1>Error!</h1>
	<p>The database info you provided isn't working properly. This is caused by one of two things:</p>
	<ul>
		<li>Incorrect database name</li>
		<li>Insufficient privileges for that user to access the database</li>
	</ul>
	<p>Please go back and try again.</p>
	</div>
<?php bodyFooter('error', $start_time); exit(); }

### First, let's write the first file: config_database.php
/*
Let's test to make sure we can actually open up config_database.php in order to add values to it.
If not, produce an error.
*/
$open_file = @fopen("../config_database.php", "w");
	if (!$open_file) { ?>
		<h1>Error!</h1>
		<p>The script could not open up config_database.php. Please verify its permissions and try again.</p>
		<p>Please go back and try again.</p>
		</div>
	<?php bodyFooter('error', $start_time); exit(); }

/*
Declare what the contents of config_database.php will be.
This includes all the data that was passed from the previous page.
*/
$file_contents = <<<EOD
<?php
\$db_host = "$db_host";
\$db_user = "$db_user";
\$db_pass = "$db_pass";
\$db_name = "$db_name";
\$db_table_prefix = "$db_table_prefix";

\$adlogger_db_connect = mysql_connect("\$db_host", "\$db_user", "\$db_pass");
\$adlogger_db_select = mysql_select_db("\$db_name");

\$siteurl = "$siteurl";
\$adlogger_loc = "$adlogger_loc";
?>
EOD;

// Write all that stuff to the file.
fwrite($open_file, "$file_contents");

// Close the file.  We don't need to edit it any more.
fclose($open_file);



### Now, let's write our second file: config_admin.php
/*
Let's test to make sure we can actually open up config_admin.php in order to add values to it.
If not, produce an error.
*/
$open_file = @fopen("../config_admin.php", "w");
	if (!$open_file) { ?>
		<h1>Error!</h1>
		<p>The script could not open up config_database.php. Please verify its permissions and try again.</p>
		<p>Please go back and try again.</p>
		</div>
	<?php bodyFooter('error', $start_time); exit(); }

/*
The login hash is a value unique to this user's installation of AdLogger.
It is used as the login session and Remember Me cookie.
*/
$login_hash = createRandomString(75);

/*
Declare what the contents of config_database.php will be.
This includes all the data that was passed from the previous page.
*/
$file_contents = <<<EOD
<?php

\$ip_info_url = "http://www.dnsstuff.com/tools/ipall.ch?domain=";

\$adlogger_doc_path = "$adlogger_doc_path";

\$admin_cookie = \$db_table_prefix . "adminglog";

\$login_hash = "$login_hash";

\$gd_enabled = $gd_enabled;

\$version_num = '$version_num';

?>
EOD;

// Write all that stuff to the file.
fwrite($open_file, "$file_contents");

// Close the file.  We don't need to edit it any more.
fclose($open_file);




/*
Now that we know the database info is correct, let's add stuff to it.
This will setup the tables and structure.
*/
// Include the database configuration we just setup so we can access the database.
require ("../config_database.php");

/*
This is the SQL code that will build the tables and insert preliminary data.
*/
$sql_install[0] = "
		CREATE TABLE IF NOT EXISTS " . $db_table_prefix . "adcheck_logs (
			`id` int(12) NOT NULL auto_increment,
			`timestamp` varchar(12) NOT NULL default '',
			`visitor_ip` varchar(15) NOT NULL default '',
			PRIMARY KEY  (`id`)
		) ENGINE=MyISAM;
	";

$sql_install[1] = "CREATE TABLE IF NOT EXISTS " . $db_table_prefix . "blocklogs (
			`id` int(11) NOT NULL auto_increment,
			`timestamp` varchar(12) NOT NULL default '',
			`visitor_ip` varchar(15) NOT NULL default '',
			`reason` int(1) NOT NULL default '0',
			`blocked_url` varchar(250) NOT NULL default '',
			PRIMARY KEY  (`id`)
		) ENGINE=MyISAM;
	";

$sql_install[2] = "CREATE TABLE IF NOT EXISTS " . $db_table_prefix . "channels (
			`id` int(4) NOT NULL auto_increment,
			`chan_name` varchar(50) NOT NULL default '',
			`chan_desc` varchar(250) NOT NULL default '',
			PRIMARY KEY  (`id`)
		) ENGINE=MyISAM;
	";

$sql_install[3] = "CREATE TABLE IF NOT EXISTS " . $db_table_prefix . "logfiles (
			`id` int(12) NOT NULL auto_increment,
			`timestamp` int(12) NOT NULL,
			`visitor_ip` varchar(15) NOT NULL default '',
			`visitor_agent` varchar(250) NOT NULL default '',
			`ch_id` int(4) NOT NULL,
			`disp_url` varchar(250) NOT NULL default '',
			`ref` varchar(250) NOT NULL default '',
			`targ_url` varchar(50) NOT NULL default '',
			`click_type` int(1) NOT NULL,
			`disp_time` int(12) NOT NULL,
			`format` varchar(16) NOT NULL default '',
			`color_bg` varchar(6) NOT NULL default '',
			`color_txt` varchar(6) NOT NULL default '',
			`color_lnk` varchar(6) NOT NULL default '',
			`color_url` varchar(6) NOT NULL default '',
			`color_brd` varchar(6) NOT NULL default '',
			`ad_type` varchar(10) NOT NULL default '',
			PRIMARY KEY  (`id`)
		) ENGINE=MyISAM;
	";

$sql_install[4] = "CREATE TABLE IF NOT EXISTS " . $db_table_prefix . "quickstats (

			`id` int(1) NOT NULL default '0',

			`last_update_time` int(12) NOT NULL default '0',

			`index.today.total` int(8) NOT NULL default '0',
			`index.today.unique` int(8) NOT NULL default '0',
			`index.today.ads` int(8) NOT NULL default '0',
			`index.today.links` int(8) NOT NULL default '0',
			`index.yesterday.total` int(8) NOT NULL default '0',
			`index.yesterday.unique` int(8) NOT NULL default '0',
			`index.yesterday.ads` int(8) NOT NULL default '0',
			`index.yesterday.links` int(8) NOT NULL default '0',
			`index.week.total` int(8) NOT NULL default '0',
			`index.week.unique` int(8) NOT NULL default '0',
			`index.week.ads` int(8) NOT NULL default '0',
			`index.week.links` int(8) NOT NULL default '0',
			`index.overall.total` int(8) NOT NULL default '0',
			`index.overall.unique` int(8) NOT NULL default '0',
			`index.overall.ads` int(8) NOT NULL default '0',
			`index.overall.links` int(8) NOT NULL default '0',

			`block.today.total` int(8) NOT NULL default '0',
			`block.today.unique` int(8) NOT NULL default '0',
			`block.yesterday.total` int(8) NOT NULL default '0',
			`block.yesterday.unique` int(8) NOT NULL default '0',
			`block.week.total` int(8) NOT NULL default '0',
			`block.week.unique` int(8) NOT NULL default '0',

			`db_size` int(20) NOT NULL default '0',

			PRIMARY KEY  (`id`)
		) ENGINE=MyISAM;
	";

$sql_install[5] = "INSERT INTO " . $db_table_prefix . "quickstats VALUES (1, 530659320, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);";
$sql_install[6] = "INSERT INTO " . $db_table_prefix . "quickstats VALUES (2, 530659320, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);";
$sql_install[7] = "INSERT INTO " . $db_table_prefix . "quickstats VALUES (3, 530659320, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);";

$sql_install[8] = "CREATE TABLE IF NOT EXISTS " . $db_table_prefix . "users (
			`id` int(2) NOT NULL auto_increment,
			`username` varchar(15) NOT NULL default '',
			`password` varchar(50) NOT NULL default '',
			PRIMARY KEY  (`id`)
		) ENGINE=MyISAM;
	";

foreach ($sql_install as $sql) {
	$sql = trim($sql);

	// And finally execute each query
	mysql_query($sql);
}

/*
Looking good so far.  Now let the user customize the script and make some changes.
*/

?>

	<h1>Steps Completed</h1>
	<p>Saving database connection info... complete.<br />Setting up tables in database... complete.</p>
	<h1>AdLogger Settings</h1>
	<p>Please setup your initial settings. These can be changed at any time in your administration panel.</p>

	<form name="install_step_3" method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>" onsubmit="return validate_step_3(this);">
			<fieldset>
				<legend>Administration Panel Access</legend>
				<label for="username"><strong>Username:</strong></label>
				<input name="username" type="text" id="username" />
				<br />
				<br />

				<label for="password1"><strong>Password:</strong></label>
				<input name="password1" type="password" id="password1" />
				<br />
				<br />

				<label for="password1"><strong>Confirm Password:</strong></label>
				<input name="password2" type="password" id="password2" />
				<br />
				<br />
			</fieldset>

		<br />

			<fieldset>
			<legend>Timezone Setting</legend>

				<div align="center">
				<br />
				Your server's time is set at <?php echo date('g:i A', time()) . " on " . date('l, F jS, Y', time()); ?>.
				<br /><br />
				If that is not correct, choose the correct time from this list of choices.
				<br /><br />
					<select name="timezone">
						<option value="-12"> - 12:00 ---- <?php time_change(-12); ?></option>
						<option value="-11"> - 11:00 ---- <?php time_change(-11); ?></option>
						<option value="-10"> - 10:00 ---- <?php time_change(-10); ?></option>
						<option value="-9"> - 9:00 ---- <?php time_change(-9); ?></option>
						<option value="-8"> - 8:00 ---- <?php time_change(-8); ?></option>
						<option value="-7"> - 7:00 ---- <?php time_change(-7); ?></option>
						<option value="-6"> - 6:00 ---- <?php time_change(-6); ?></option>
						<option value="-5"> - 5:00 ---- <?php time_change(-5); ?></option>
						<option value="-4"> - 4:00 ---- <?php time_change(-4); ?></option>
						<option value="-3.5"> - 3:30 ---- <?php time_change(-3.5); ?></option>
						<option value="-3"> - 3:00 ---- <?php time_change(-3); ?></option>
						<option value="-2"> - 2:00 ---- <?php time_change(-2); ?></option>
						<option value="-1"> - 1:00 ---- <?php time_change(-1); ?></option>
						<option value="0" selected="selected"> + 0:00 ---- <?php time_change(0); ?></option>
						<option value="1"> + 1:00 ---- <?php time_change(1); ?></option>
						<option value="2"> + 2:00 ---- <?php time_change(2); ?></option>
						<option value="3"> + 3:00 ---- <?php time_change(3); ?></option>
						<option value="3.5"> + 3:30 ---- <?php time_change(3.5); ?></option>
						<option value="4"> + 4:00 ---- <?php time_change(4); ?></option>
						<option value="4.5"> + 4:30 ---- <?php time_change(4.5); ?></option>
						<option value="5"> + 5:00 ---- <?php time_change(5); ?></option>
						<option value="5.5"> + 5:30 ---- <?php time_change(5.5); ?></option>
						<option value="6"> + 6:00 ---- <?php time_change(6); ?></option>
						<option value="7"> + 7:00 ---- <?php time_change(7); ?></option>
						<option value="8"> + 8:00 ---- <?php time_change(8); ?></option>
						<option value="9"> + 9:00 ---- <?php time_change(9); ?></option>
						<option value="9.5"> + 9:30 ---- <?php time_change(9.5); ?></option>
						<option value="10"> + 10:00 ---- <?php time_change(10); ?></option>
						<option value="11"> + 11:00 ---- <?php time_change(11); ?></option>
						<option value="12"> + 12:00 ---- <?php time_change(12); ?></option>
					</select>
					<br />
				</div>

			<br />
		</fieldset>

		<br />

			<fieldset>
				<legend>Notification Settings</legend>
				<label for="email"><strong>Email Address: </strong></label>
				<input name="email" type="text" id="email" size="30" />
				<br />
				<br />
				<label for="email"><strong>Confirm Email: </strong></label>
				<input name="email_confirm" type="text" id="email_confirm" size="30" />
				<br />
				<br />

				<label for="emailnotice"><strong>Email Notice: </strong></label>
				<input name="emailnotice" type="radio" value="true" checked="checked" /> Yes
				<input name="emailnotice" type="radio" value="false" /> No
				<br />
				<label>Would you like to receive an email after every reported click?</label>
				<br />
				<br />

				<label for="emailalert"><strong>Email Alert: </strong></label>
				<input name="emailalert" type="radio" value="true" checked="checked" /> Yes
				<input name="emailalert" type="radio" value="false" /> No
				<br />
				<label>Would you like to receive an email after multiple clicks from the same IP address?</label>
				<br />
				<br />
			</fieldset>

		<br />

			<fieldset>
				<legend>Click Fraud Settings (Optional)</legend>
				<div align="center">
				A visitor can click a maximum of <input name="clickmax" type="text" size="3" /> ads every <input name="clickmaxtime" type="text" size="3" /> hour(s).
				</div>
				<br />

			</fieldset>

		<br />

			<fieldset>
				<legend>Continue</legend>
				<label for="submit">&nbsp;</label>
				<input name="step" type="hidden" id="step" value="5" />
				<input type="submit" name="Submit" value="Continue" />
			</fieldset>

	</form>



<?php }
/*
If the user is at step 5, perform this code
*/
elseif ($_POST['step'] == '5') {

// Get and declare all the variables that have been posted from the previous step
$username = $_POST['username'];
$password1 = $_POST['password1'];
$password2 = $_POST['password2'];
$gmtdifference = $_POST['timezone'];
$email = trim($_POST['email']);
$email_confirm = trim($_POST['email_confirm']);
$emailnotice = $_POST['emailnotice'];
$emailalert = $_POST['emailalert'];
$clickmax = $_POST['clickmax'];
$clickmaxtime = $_POST['clickmaxtime'];

/*
If the user left the click fraud values blank,
insert two numbers in there so the script won't produce an error.
*/
if (empty($clickmax)) $clickmax = 99;
if (empty($clickmaxtime)) $clickmaxtime = 1;

/*
Verify that the user didn't leave anything in the form blank.
*/
if (empty($username) || empty($password1) || empty($password2) || empty($email) || empty($email_confirm)) { ?>
	<h1>Error!</h1>
	<p>You must fill out the form completely. Do not leave any of the following blank:</p>
	<ul>
		<li>Username</li>
		<li>Password</li>
		<li>Password Confirmation</li>
		<li>Email Address</li>
		<li>Email Confirmation</li>
	</ul>
	<p>Please go back and try again.</p>
	</div>
<?php bodyFooter('error', $start_time); exit(); }

// Verify that the password and confirmation password are the same.
if ($password1 != $password2) { ?>
	<h1>Error!</h1>
	<p>Your two passwords must match.</p>
	<ul>
		<li>Password</li>
		<li>Confirmation Password</li>
	</ul>
	<p>Please go back and try again.</p>
	</div>
<?php bodyFooter('error', $start_time); exit(); }

// Verify that the password is at least 6 characters long.
if (strlen($password1) < 6) { ?>
	<h1>Error!</h1>
	<p>Your password should be at least 6 characters in length for security reasons.</p>
	<p>Please go back and try again.</p>
	</div>
<?php bodyFooter('error', $start_time); exit(); }

// Verify that the email and confirmation email are the same.
if ($email != $email_confirm) { ?>
	<h1>Error!</h1>
	<p>Your two email addresses must match.</p>
	<ul>
		<li>Email</li>
		<li>Email Confirmation</li>
	</ul>
	<p>Please go back and try again.</p>
	</div>
<?php bodyFooter('error', $start_time); exit(); }

// Make sure that the email address is a valid email address.
if (!is_valid_email("$email")) { ?>
	<h1>Error!</h1>
	<p><?php echo $email; ?> does not appear to be a valid email address. Please enter a valid email address. If you do not, the script may produce more errors.</p>
	<p>Please go back and try again.</p>
	</div>
<?php bodyFooter('error', $start_time); exit(); }

// Verify that the click fraud settings are actually numbers.
if (!is_numeric($clickmax) || !is_numeric($clickmaxtime)) { ?>
	<h1>Error!</h1>
	<p>The maximum click levels must be numeric.</p>
	<p>Please go back and try again.</p>
	</div>
<?php bodyFooter('error', $start_time); exit(); }

/*
Let's test to make sure we can actually open up config_settings.php in order to add values to it.
If not, produce an error.
*/
$open_file = @fopen("../config_settings.php", "w");
	if (!$open_file) { ?>
		<h1>Error!</h1>
		<p>The script could not open up config_settings.php. Please verify its permissions and try again.</p>
		<p>Please go back and try again.</p>
		</div>
	<?php bodyFooter('error', $start_time); exit(); }

/*
Declare what the contents of config_database.php will be.
This includes all the data that was passed from the previous page.
*/
$file_contents = <<<EOD
<?php
/*
 * You can change these on the Settings page inside your Administration panel.
 */

\$email = "$email";

\$email_notice = $emailnotice;

\$email_alert = $emailalert;

\$emailalert_num = 5;

\$clickmax = $clickmax;

\$clickmaxtime = $clickmaxtime * 3600;

\$gmt_dif = "$gmtdifference";

\$timestamp = time() + 60*60*(\$gmt_dif);

\$ip_db_check = true;

\$ip_range_ban_list = array(
""
);

\$disable_all_ads = false;

?>
EOD;

// Write all that stuff to the file.
fwrite($open_file, "$file_contents");

// Close the file.  We don't need to edit it any more.
fclose($open_file);

// End of writing config_settings.php file
//

/*
Open up both configuration files because we know need
to know the values that are stored in each of them.
*/
require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");

/*
We don't want to store the password in the database as plain text.
So let's hash it using 160-bit hash: SHA-1
*/
$password_hash = sha1($password1);

// Now insert the username and hashed password into the database.
mysql_query("INSERT INTO " . $db_table_prefix . "users
	SET
	username='$username',
	password='$password_hash'
")
or die(mysql_error());

/*
That's pretty much it with the installation.
Now tell the user what else he has to do to clean up and start using AdLogger!
*/
?>
	<h1>Steps Completed</h1>
	<p>
		Saving database connection info... complete.
		<br />
		Setting up tables in database... complete.
		<br />Saving settings... complete.
	</p>
	<p><strong>Congratulations! AdLogger has been installed successfully!</strong></p>

	<h1>Post Installation Instructions</h1>
	<ul>
		<li>Delete the installation directory (/install).</li>

		<?php
		// Try to automatically change permissions on the config files back to 644.
		@chmod('../config_admin.php', 0644);
		@chmod('../config_database.php', 0644);
		@chmod('../config_settings.php', 0644);

		/*
		Check the configuration files permissions to see if they're already set back.
		If not, tell the user he'll have to do it manually.
		*/
		if (check_permissions('../config_admin.php') && check_permissions('../config_database.php') && check_permissions('../config_settings.php')) {
			echo '<li>CHMOD the configuration files back to 644.</li>';
		}
		?>
	</ul>

	<p><strong>Login Information: </strong>You can log in to your administration panel at the following url: <a href="<?php echo $siteurl . $adlogger_loc; ?>"><?php echo $siteurl . $adlogger_loc; ?></a></p>

<?php
/*
Send a confirmation email to the user telling them they're good to go.
Also contains the post-installation instructions.
*/
$msg = "Congratulations! AdLogger has been successfully installed. You are now ready to being using it.<BR><BR>
Before AdLogger can begin recording stats, you must place a piece of javascript code on each of your AdSense pages. This code can be found on the Code Generator page in your admin panel.<BR><BR>
To become fully aware of the strengths and shortcomings of the AdLogger script, please read the documentation and frequently asked questions: http://www.adlogger.org/index.php/Documentation<BR><BR>
If you run into any problems whatsoever, please fill out a bug report and submit it in the support forum.<BR><BR>
You can accesss your administration panel at the following URL: $siteurl$adlogger_loc<BR><BR>
Thanks and enjoy!<BR><BR>
Trevor Fitzgerald<BR>
AdLogger Founder";

$subject = "AdLogger Installation";
$mailheaders = "MIME-Version: 1.0\n";
$mailheaders .= "Content-type: text/html; charset=iso-8859-1\n";

$to = $email;
$mailheaders .= "From: AdLogger <$email>\n";
$mailheaders .= "Reply-To: $email";

mail($to, $subject, $msg, $mailheaders);

}
/*
If, for some reason, the POST variables weren't working
to send the user to the next step, produce an error.
*/
else { ?>
	<h1>Error!</h1>
	<p>There seems to be a problem sending you to the next step of the installation.</p>
	</div>
	<?php bodyFooter('error', $start_time); exit(); ?>
<?php } ?>

</div>

<?php
// Output the closing HTML code
bodyFooter('install', $start_time);

/* Ta da! */
?>